# Requirements Document - Modul Pendaftaran Peserta Didik

## Introduction

Modul Pendaftaran Peserta Didik adalah sistem manajemen pendaftaran siswa baru yang memungkinkan calon siswa mendaftar secara online, operator memverifikasi data, dan admin mengelola seluruh proses pendaftaran. Sistem ini dirancang dengan role-based access control untuk memisahkan hak akses antara Admin, Operator, dan Siswa.

## Glossary

- **System**: Modul Pendaftaran Peserta Didik
- **Admin**: Pengguna dengan hak akses penuh untuk mengelola pengaturan sistem, melihat laporan, dan mengatur status pendaftaran
- **Operator**: Pengguna yang bertugas memverifikasi dokumen dan data pendaftaran siswa
- **Siswa**: Calon peserta didik yang melakukan pendaftaran melalui sistem
- **Registration Form**: Formulir pendaftaran online yang diisi oleh calon siswa
- **Registration Status**: Status pendaftaran (pending, verified, accepted, rejected)
- **Document Upload**: Fitur untuk mengunggah dokumen pendukung (foto, ijazah, kartu keluarga)
- **Registration Number**: Nomor unik yang diberikan kepada setiap pendaftar
- **Academic Year**: Tahun ajaran untuk periode pendaftaran

## Requirements

### Requirement 1

**User Story:** Sebagai calon siswa, saya ingin mendaftar secara online dengan mengisi formulir lengkap, sehingga saya dapat mendaftar tanpa harus datang ke sekolah

#### Acceptance Criteria

1. WHEN calon siswa mengakses halaman pendaftaran, THE System SHALL menampilkan formulir pendaftaran dengan field data pribadi, data orang tua, dan sekolah asal
2. WHEN calon siswa mengisi formulir pendaftaran, THE System SHALL memvalidasi setiap field untuk memastikan data yang dimasukkan sesuai format
3. WHEN calon siswa mengunggah dokumen, THE System SHALL memvalidasi tipe file (jpg, png, pdf) dan ukuran maksimal 2MB
4. WHEN calon siswa mengirim formulir pendaftaran, THE System SHALL menyimpan data ke database dan menghasilkan Registration Number unik
5. WHEN pendaftaran berhasil disimpan, THE System SHALL menampilkan Registration Number dan mengirim notifikasi konfirmasi

### Requirement 2

**User Story:** Sebagai siswa yang sudah mendaftar, saya ingin melihat status pendaftaran saya, sehingga saya dapat mengetahui perkembangan proses pendaftaran

#### Acceptance Criteria

1. WHEN siswa mengakses halaman cek status, THE System SHALL menampilkan form input untuk Registration Number atau NISN
2. WHEN siswa memasukkan Registration Number yang valid, THE System SHALL menampilkan detail pendaftaran dan status terkini
3. WHEN siswa memasukkan Registration Number yang tidak valid, THE System SHALL menampilkan pesan error yang informatif
4. WHILE status pendaftaran adalah "accepted", THE System SHALL menampilkan tombol untuk mencetak kartu pendaftaran

### Requirement 3

**User Story:** Sebagai operator, saya ingin memverifikasi data dan dokumen pendaftaran siswa, sehingga saya dapat memastikan kelengkapan dan kebenaran data

#### Acceptance Criteria

1. WHEN operator login ke sistem, THE System SHALL menampilkan dashboard dengan daftar pendaftaran yang perlu diverifikasi
2. WHEN operator membuka detail pendaftaran, THE System SHALL menampilkan semua data siswa dan dokumen yang diunggah
3. WHEN operator mengubah status pendaftaran, THE System SHALL menyimpan perubahan dan mencatat log aktivitas dengan timestamp dan user ID
4. WHERE operator memiliki hak akses, THE System SHALL mengizinkan operator untuk mengubah status dari pending ke verified atau rejected
5. WHEN operator melakukan pencarian, THE System SHALL menampilkan hasil berdasarkan nama, Registration Number, atau NISN

### Requirement 4

**User Story:** Sebagai admin, saya ingin mengelola pengaturan sistem pendaftaran, sehingga saya dapat mengontrol periode pendaftaran dan kuota siswa

#### Acceptance Criteria

1. WHEN admin mengakses halaman pengaturan, THE System SHALL menampilkan form untuk mengatur tanggal mulai, tanggal akhir, dan kuota pendaftaran
2. WHEN admin mengubah pengaturan, THE System SHALL menyimpan perubahan dan menerapkannya secara real-time
3. WHEN admin menutup pendaftaran, THE System SHALL menonaktifkan form pendaftaran untuk calon siswa
4. WHILE pendaftaran ditutup, THE System SHALL menampilkan pesan informasi kepada calon siswa yang mengakses halaman pendaftaran
5. WHEN admin membuka dashboard, THE System SHALL menampilkan statistik pendaftaran (total, pending, verified, accepted, rejected)

### Requirement 5

**User Story:** Sebagai admin, saya ingin melihat laporan dan statistik pendaftaran, sehingga saya dapat menganalisis data pendaftaran

#### Acceptance Criteria

1. WHEN admin mengakses halaman laporan, THE System SHALL menampilkan statistik pendaftaran berdasarkan status
2. WHEN admin memilih filter periode, THE System SHALL menampilkan data pendaftaran sesuai rentang tanggal yang dipilih
3. WHEN admin mengekspor laporan, THE System SHALL menghasilkan file Excel atau PDF dengan data pendaftaran lengkap
4. THE System SHALL menampilkan grafik visualisasi data pendaftaran per bulan dan per jurusan
5. WHEN admin melihat detail pendaftar, THE System SHALL menampilkan riwayat perubahan status lengkap dengan timestamp

### Requirement 6

**User Story:** Sebagai admin atau operator, saya ingin sistem mencatat semua aktivitas pengguna, sehingga ada audit trail untuk keamanan dan akuntabilitas

#### Acceptance Criteria

1. WHEN pengguna melakukan perubahan data, THE System SHALL mencatat aktivitas ke tabel log dengan user ID, timestamp, dan deskripsi aktivitas
2. WHEN admin mengakses log aktivitas, THE System SHALL menampilkan riwayat aktivitas dengan filter berdasarkan user dan tanggal
3. THE System SHALL mencatat setiap perubahan status pendaftaran dengan detail sebelum dan sesudah perubahan
4. THE System SHALL menyimpan log aktivitas minimal selama 1 tahun
5. WHEN terjadi login atau logout, THE System SHALL mencatat aktivitas tersebut ke log sistem

### Requirement 7

**User Story:** Sebagai pengguna sistem, saya ingin sistem memiliki keamanan yang baik, sehingga data pendaftaran terlindungi dari akses tidak sah

#### Acceptance Criteria

1. WHEN pengguna mengakses halaman yang memerlukan autentikasi, THE System SHALL memvalidasi session dan role pengguna
2. WHEN pengguna mencoba mengakses halaman tanpa hak akses, THE System SHALL menampilkan pesan error dan redirect ke halaman login
3. THE System SHALL menggunakan prepared statements untuk semua query database guna mencegah SQL injection
4. THE System SHALL memvalidasi dan sanitasi semua input pengguna sebelum diproses
5. WHEN pengguna mengunggah file, THE System SHALL memvalidasi tipe file dan ukuran untuk mencegah upload file berbahaya

### Requirement 8

**User Story:** Sebagai sistem, saya perlu memiliki struktur folder yang terorganisir, sehingga kode mudah dipelihara dan dikembangkan

#### Acceptance Criteria

1. THE System SHALL mengorganisir file dalam folder terpisah untuk admin, operator, siswa, dan shared components
2. THE System SHALL menyimpan file upload dalam folder terpisah dengan struktur berdasarkan tahun dan bulan
3. THE System SHALL memiliki file konfigurasi terpisah untuk database dan pengaturan aplikasi
4. THE System SHALL memiliki folder assets terpisah untuk CSS, JavaScript, dan gambar
5. THE System SHALL menyediakan dokumentasi instalasi dan penggunaan dalam file README
