# Panduan Backup MySQL untuk phpMyAdmin

## 📋 Daftar Isi
1. [Cara Membuat Backup MySQL](#cara-membuat-backup-mysql)
2. [Cara Upload ke phpMyAdmin](#cara-upload-ke-phpmyadmin)
3. [Perbedaan Format](#perbedaan-format)
4. [Troubleshooting](#troubleshooting)

---

## 🔄 Cara Membuat Backup MySQL

### Langkah 1: Login ke Admin Panel
1. Buka browser dan akses admin panel
2. Login dengan akun admin
3. Klik menu **"Backup & Restore Database"**

### Langkah 2: Pilih Format MySQL
1. Di bagian **"Backup Database"**, cari form **"Backup Format SQL (.sql)"**
2. Pilih radio button **"MySQL/MariaDB SQL"**
3. Klik tombol **"Backup Format SQL (.sql)"**
4. Konfirmasi backup

### Langkah 3: Download File Backup
1. File backup akan muncul di daftar backup dengan nama seperti: `backup_2024-01-15_14-30-45_mysql.sql`
2. Klik tombol **Download** (ikon download hijau)
3. Simpan file di komputer Anda

---

## 📤 Cara Upload ke phpMyAdmin

### Metode 1: Import via phpMyAdmin (Recommended)

#### Langkah 1: Buka phpMyAdmin
1. Akses phpMyAdmin (biasanya: `http://localhost/phpmyadmin`)
2. Login dengan username dan password MySQL Anda

#### Langkah 2: Buat Database Baru (Opsional)
1. Klik tab **"Databases"**
2. Masukkan nama database baru (contoh: `school_backup`)
3. Pilih **Collation**: `utf8mb4_unicode_ci`
4. Klik **"Create"**

#### Langkah 3: Import File SQL
1. Pilih database yang ingin diisi (klik nama database di sidebar kiri)
2. Klik tab **"Import"** di bagian atas
3. Klik tombol **"Choose File"** atau **"Browse"**
4. Pilih file backup MySQL yang sudah didownload (contoh: `backup_2024-01-15_14-30-45_mysql.sql`)
5. Pastikan format: **SQL**
6. Klik tombol **"Go"** atau **"Import"** di bagian bawah

#### Langkah 4: Verifikasi Import
1. Setelah import selesai, akan muncul pesan sukses
2. Klik tab **"Structure"** untuk melihat tabel yang ter-import
3. Klik nama tabel untuk melihat data

### Metode 2: Import via Command Line (Advanced)

```bash
# Login ke MySQL
mysql -u root -p

# Buat database baru (opsional)
CREATE DATABASE school_backup CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

# Keluar dari MySQL
exit;

# Import file SQL
mysql -u root -p school_backup < backup_2024-01-15_14-30-45_mysql.sql
```

---

## 📊 Perbedaan Format Backup

### 1. SQLite Binary (.db)
- ✅ **Kelebihan:**
  - Backup paling cepat
  - Ukuran file kecil
  - Restore instant (copy file)
  - Tidak perlu konversi
- ❌ **Kekurangan:**
  - Hanya untuk SQLite
  - Tidak bisa dibaca manusia
  - Tidak bisa diedit

### 2. SQLite SQL (.sql)
- ✅ **Kelebihan:**
  - Bisa dibaca dan diedit
  - Portable antar sistem
  - Bisa di-version control (Git)
- ❌ **Kekurangan:**
  - Tidak compatible dengan MySQL
  - Syntax khusus SQLite
  - Ukuran file lebih besar

### 3. MySQL SQL (.sql) ⭐ **RECOMMENDED untuk phpMyAdmin**
- ✅ **Kelebihan:**
  - **Compatible dengan phpMyAdmin** ✓
  - **Bisa di-import ke MySQL/MariaDB** ✓
  - Bisa dibaca dan diedit
  - Portable ke berbagai database
  - Syntax standar MySQL
- ❌ **Kekurangan:**
  - Proses backup sedikit lebih lama
  - Ukuran file lebih besar

---

## 🔍 Perbedaan Syntax

### SQLite SQL Format:
```sql
-- SQLite Database Backup
CREATE TABLE users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    email TEXT UNIQUE
);

INSERT INTO users VALUES (1, 'John Doe', 'john@example.com');
```

### MySQL SQL Format:
```sql
-- MySQL Database Backup
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

CREATE TABLE `users` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` TEXT NOT NULL,
  `email` TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `users` (`id`, `name`, `email`) VALUES
(1, 'John Doe', 'john@example.com');
```

---

## 🛠️ Troubleshooting

> 📖 **Panduan Lengkap:** Lihat [MYSQL_IMPORT_TROUBLESHOOTING.md](MYSQL_IMPORT_TROUBLESHOOTING.md) untuk troubleshooting detail dengan screenshot dan contoh.

### Problem 1: File Terlalu Besar untuk Upload
**Error:** "The uploaded file exceeds the upload_max_filesize directive in php.ini"

**Solusi:**
1. Edit file `php.ini`:
   ```ini
   upload_max_filesize = 100M
   post_max_size = 100M
   max_execution_time = 300
   ```
2. Restart Apache/Nginx
3. Atau gunakan command line import

### Problem 2: Timeout saat Import
**Error:** "Script timeout passed"

**Solusi:**
1. Edit `php.ini`:
   ```ini
   max_execution_time = 600
   ```
2. Atau gunakan command line import
3. Atau split file SQL menjadi beberapa bagian

### Problem 3: Syntax Error saat Import
**Error:** "You have an error in your SQL syntax"

**Solusi:**
1. Pastikan Anda memilih format **"MySQL/MariaDB SQL"** saat backup
2. Jangan gunakan file backup SQLite SQL untuk MySQL
3. Buat backup baru dengan format yang benar

### Problem 4: Charset/Encoding Issues
**Error:** Karakter aneh atau tidak terbaca

**Solusi:**
1. Pastikan database MySQL menggunakan `utf8mb4_unicode_ci`
2. Saat import, pilih charset: **utf-8**
3. File backup sudah otomatis menggunakan UTF-8

### Problem 5: Foreign Key Constraints
**Error:** "Cannot add or update a child row: a foreign key constraint fails"

**Solusi:**
1. Disable foreign key checks sementara:
   ```sql
   SET FOREIGN_KEY_CHECKS=0;
   -- Import SQL file here
   SET FOREIGN_KEY_CHECKS=1;
   ```
2. Atau import ke database kosong

---

## 📝 Tips & Best Practices

### 1. Backup Rutin
- Buat backup sebelum update besar
- Jadwalkan backup otomatis (mingguan/bulanan)
- Simpan backup di lokasi berbeda (cloud storage)

### 2. Naming Convention
- File backup otomatis diberi nama dengan timestamp
- Format: `backup_YYYY-MM-DD_HH-MM-SS_mysql.sql`
- Mudah untuk tracking dan sorting

### 3. Testing Backup
- Test restore backup secara berkala
- Verifikasi data setelah restore
- Pastikan semua tabel dan data lengkap

### 4. Security
- Jangan share file backup di public
- Encrypt file backup jika berisi data sensitif
- Gunakan password untuk database MySQL

### 5. Storage Management
- Hapus backup lama yang tidak diperlukan
- Compress file backup (zip/gzip) untuk menghemat space
- Monitor ukuran folder backup

---

## 🎯 Workflow Recommended

### Untuk Development:
1. Gunakan **SQLite Binary (.db)** untuk backup harian
2. Cepat dan efisien
3. Restore instant

### Untuk Migration ke MySQL:
1. Gunakan **MySQL SQL (.sql)** format
2. Upload ke phpMyAdmin
3. Test di environment baru

### Untuk Version Control:
1. Gunakan **SQLite SQL (.sql)** format
2. Commit ke Git repository
3. Track perubahan database schema

### Untuk Disaster Recovery:
1. Backup semua format
2. Simpan di multiple locations
3. Test restore procedure

---

## 📞 Support

Jika mengalami masalah:
1. Cek log error di phpMyAdmin
2. Cek log Apache/MySQL
3. Verifikasi format backup yang digunakan
4. Pastikan versi MySQL compatible (5.7+)

---

## ✅ Checklist Import ke phpMyAdmin

- [ ] Backup dibuat dengan format **"MySQL/MariaDB SQL"**
- [ ] File backup sudah didownload
- [ ] phpMyAdmin sudah dibuka dan login
- [ ] Database target sudah dipilih/dibuat
- [ ] File size tidak melebihi `upload_max_filesize`
- [ ] Charset database: `utf8mb4_unicode_ci`
- [ ] Klik Import dan pilih file
- [ ] Verifikasi data setelah import

---

**Selamat! Database SQLite Anda sekarang bisa di-backup dan di-import ke MySQL/phpMyAdmin! 🎉**
