<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_login();
$db = get_db();

$id = (int)($_GET['id'] ?? 0);
$stmt = $db->prepare('SELECT * FROM students WHERE id = :id');
$stmt->execute([':id'=>$id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$student) {
    header('Location: students.php');
    exit;
}

require __DIR__ . '/_header.php';
?>

<h1>Edit Siswa</h1>
<form method="post" action="students.php" enctype="multipart/form-data">
  <input type="hidden" name="action" value="update">
  <input type="hidden" name="id" value="<?php echo e($student['id']); ?>">
  <div class="form-group">
    <label>NIS</label>
    <input name="nis" value="<?php echo e($student['nis']); ?>" class="form-control">
  </div>
  <div class="form-group">
    <label>Nama</label>
    <input name="name" value="<?php echo e($student['name']); ?>" class="form-control">
  </div>
  <div class="form-group">
    <label>Kelas</label>
    <input name="grade" value="<?php echo e($student['grade']); ?>" class="form-control">
  </div>
  <div class="form-group">
    <label>Ganti Foto (opsional)</label>
    <input type="file" name="photo" class="form-control-file">
    <?php if (!empty($student['photo'])): ?>
      <div class="mt-2"><img src="/data/uploads/<?php echo e($student['photo']); ?>" style="width:96px;height:96px;object-fit:cover"></div>
    <?php endif; ?>
  </div>
  <button class="btn btn-primary">Simpan</button>
  <a href="students.php" class="btn btn-secondary">Batal</a>
</form>

<?php
require __DIR__ . '/_footer.php';
?>