<?php
require_once __DIR__ . '/../includes/functions.php';
$siteName = get_setting('site_name', 'Sekolah Kita');
$siteLogo = get_setting('site_logo', '');
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo e($siteName); ?> - Website Sekolah</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;800&display=swap" rel="stylesheet">
  <link href="<?php echo base_url(); ?>/assets/vendor/bootstrap5/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?php echo base_url(); ?>/public/assets/css/style.css" rel="stylesheet">
  <style>
/* Logo styling */
.navbar-brand img {
  transition: transform 0.2s ease;
}
.navbar-brand:hover img {
  transform: scale(1.05);
}

/* Responsive logo */
@media (max-width: 576px) {
  .navbar-brand img {
    height: 32px !important;
  }
  .navbar-brand span {
    font-size: 0.9rem;
  }
}

/* Search modal */
@media (max-width: 767px) {
  #searchModal .modal-dialog {
    max-width: 98vw;
    margin: 0.5rem auto;
  }
  #searchModal .modal-content {
    border-radius: 1.1rem;
  }
}
#searchModal { z-index: 2000; }
#searchModal .modal-dialog { z-index: 2100; }
.modal-backdrop.show { z-index: 1999 !important; }
#searchModal .modal-content { box-shadow: 0 8px 32px rgba(0,0,0,0.18); }
</style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
  <div class="container">
    <a class="navbar-brand d-flex align-items-center" href="<?php echo base_url(); ?>/public/index.php">
      <?php if ($siteLogo): ?>
        <img src="<?php echo base_url(); ?>/data/uploads/<?php echo e($siteLogo); ?>" 
             alt="<?php echo e($siteName); ?>" 
             class="me-2" 
             style="height: 40px; width: auto; object-fit: contain;">
      <?php endif; ?>
      <span><?php echo e($siteName); ?></span>
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNav" aria-controls="mainNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="mainNav">
      <ul class="navbar-nav ms-auto">
<?php
  $nav_json = get_setting('nav_items', '');
  $nav_items = [];
  if ($nav_json) {
    $decoded = json_decode($nav_json, true);
    if (is_array($decoded)) $nav_items = $decoded;
  }
  if (empty($nav_items)) {
    // default static items
    $nav_items = [
      ['label'=>'Beranda','href'=>base_url() . '/public/index.php'],
      ['label'=>'Tentang','href'=>base_url() . '/public/about.php'],
      ['label'=>'Siswa','href'=>base_url() . '/public/students.php'],
      ['label'=>'Guru','href'=>base_url() . '/public/teachers.php'],
      ['label'=>'Galeri','href'=>base_url() . '/public/galeri.php'],
      ['label'=>'Berita','href'=>base_url() . '/public/berita.php'],
      ['label'=>'Download','href'=>base_url() . '/public/download.php'],
      ['label'=>'Admin','href'=>base_url() . '/admin/login.php','class'=>'btn btn-sm btn-outline-primary ms-2']
    ];
  }
  // Render nav items, insert Cari button after Download dan menu Kontak setelah Download
  function render_nav($items) {
    $current = $_SERVER['REQUEST_URI'] ?? '';
    foreach ($items as $it) {
      $label = htmlspecialchars($it['label'] ?? '', ENT_QUOTES, 'UTF-8');
      $href = $it['href'] ?? '#';
      $extraClass = $it['class'] ?? '';
      $icon = isset($it['icon']) && $it['icon'] ? '<i class="' . htmlspecialchars($it['icon'], ENT_QUOTES, 'UTF-8') . ' me-1"></i>' : '';
      $hasChildren = !empty($it['children']) && is_array($it['children']);
      if ($label === 'Download') {
        echo '<li class="nav-item ms-3"><a class="nav-link" href="' . htmlspecialchars($href, ENT_QUOTES, 'UTF-8') . '">' . $icon . $label . '</a></li>';
        // Tambah menu Kontak setelah Download
        echo '<li class="nav-item ms-3"><a class="nav-link" href="' . base_url() . '/public/kontak.php">Kontak</a></li>';
        // Insert Cari button after Download
        echo '<li class="nav-item ms-2 d-flex align-items-center"><button type="button" class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#searchModal" title="Cari"><i class="fa fa-search"></i> <span class="d-none d-md-inline">Cari</span></button></li>';
        continue;
      }
      if ($hasChildren) {
        echo '<li class="nav-item dropdown ms-3">';
        echo '<a class="nav-link dropdown-toggle" href="#" id="dropdown' . md5($label) . '" role="button" data-bs-toggle="dropdown" aria-expanded="false">' . $icon . $label . '</a>';
        echo '<ul class="dropdown-menu" aria-labelledby="dropdown' . md5($label) . '">';
        foreach ($it['children'] as $child) {
          $childLabel = htmlspecialchars($child['label'] ?? '', ENT_QUOTES, 'UTF-8');
          $childHref = $child['href'] ?? '#';
          $childIcon = isset($child['icon']) && $child['icon'] ? '<i class="' . htmlspecialchars($child['icon'], ENT_QUOTES, 'UTF-8') . ' me-1"></i>' : '';
          echo '<li><a class="dropdown-item" href="' . htmlspecialchars($childHref, ENT_QUOTES, 'UTF-8') . '">' . $childIcon . $childLabel . '</a></li>';
        }
        echo '</ul>';
        echo '</li>';
      } else if (strpos($extraClass, 'btn') !== false) {
        echo '<li class="nav-item ms-2"><a class="' . htmlspecialchars($extraClass, ENT_QUOTES, 'UTF-8') . '" href="' . htmlspecialchars($href, ENT_QUOTES, 'UTF-8') . '">' . $icon . $label . '</a></li>';
      } else {
        $active = ($href !== '#' && $href !== '' && strpos($current, $href) !== false) ? ' active' : '';
        echo '<li class="nav-item ms-3"><a class="nav-link' . $active . '" href="' . htmlspecialchars($href, ENT_QUOTES, 'UTF-8') . '">' . $icon . $label . '</a></li>';
      }
    }
  }
  render_nav($nav_items);
?>
      </ul>
    </div>
  </div>
</nav>
<!-- Modal Pencarian -->
<div class="modal fade" id="searchModal" tabindex="-1" aria-labelledby="searchModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="searchModalLabel">Pencarian</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="search.php" method="get">
        <div class="modal-body">
          <input type="text" class="form-control" name="q" placeholder="Cari berita, file, guru..." autofocus required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary w-100">Cari</button>
        </div>
      </form>
    </div>
  </div>
</div>
<main>
  <div class="container" style="padding-top: 0; margin-top: 0;">
