<?php
// public/ppdb_check.php - Cek Status Pendaftaran PPDB
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/db.php';
$db = get_db();

$registration = null;
$error = '';

if (isset($_GET['reg_number'])) {
  $reg_number = $_GET['reg_number'];
  $stmt = $db->prepare("SELECT * FROM ppdb_registrations WHERE registration_number = :reg_number");
  $stmt->execute([':reg_number' => $reg_number]);
  $registration = $stmt->fetch(PDO::FETCH_ASSOC);
  
  if (!$registration) {
    $error = "Nomor pendaftaran tidak ditemukan.";
  }
}

require __DIR__ . '/_header.php';
?>

<div class="container py-5">
  <div class="row mb-4">
    <div class="col-12 text-center">
      <h1 class="display-5 fw-bold mb-3">Cek Status Pendaftaran</h1>
      <p class="lead text-muted">Masukkan nomor pendaftaran Anda</p>
    </div>
  </div>

  <div class="row">
    <div class="col-md-6 mx-auto">
      <div class="card shadow-sm">
        <div class="card-body p-4">
          <form method="GET" action="">
            <div class="mb-3">
              <label class="form-label">Nomor Pendaftaran</label>
              <input type="text" 
                     name="reg_number" 
                     class="form-control form-control-lg" 
                     placeholder="Contoh: PPDB20240001"
                     value="<?php echo e($_GET['reg_number'] ?? ''); ?>"
                     required>
            </div>
            <button type="submit" class="btn btn-primary btn-lg w-100">
              <i class="fa fa-search me-2"></i>Cek Status
            </button>
          </form>
          
          <div class="text-center mt-3">
            <a href="<?php echo base_url(); ?>/public/ppdb_register.php" class="text-decoration-none">
              <i class="fa fa-arrow-left me-1"></i>Kembali ke Pendaftaran
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php if ($error): ?>
    <div class="row mt-4">
      <div class="col-md-6 mx-auto">
        <div class="alert alert-danger">
          <i class="fa fa-exclamation-circle me-2"></i><?php echo e($error); ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php if ($registration): ?>
    <div class="row mt-4">
      <div class="col-md-8 mx-auto">
        <div class="card shadow">
          <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="fa fa-id-card me-2"></i>Informasi Pendaftaran</h5>
          </div>
          <div class="card-body">
            <div class="row mb-4">
              <div class="col-md-6">
                <h6 class="text-muted mb-3">Data Pendaftar</h6>
                <table class="table table-sm">
                  <tr>
                    <td width="150">Nomor Pendaftaran</td>
                    <td><strong><?php echo e($registration['registration_number']); ?></strong></td>
                  </tr>
                  <tr>
                    <td>Nama Lengkap</td>
                    <td><strong><?php echo e($registration['full_name']); ?></strong></td>
                  </tr>
                  <tr>
                    <td>Tanggal Daftar</td>
                    <td><?php echo date('d F Y', strtotime($registration['created_at'])); ?></td>
                  </tr>
                </table>
              </div>
              <div class="col-md-6 text-center">
                <?php if ($registration['photo']): ?>
                  <img src="<?php echo base_url(); ?>/data/uploads/ppdb/<?php echo e($registration['photo']); ?>" 
                       alt="Foto" 
                       class="img-thumbnail" 
                       style="max-width: 150px;">
                <?php endif; ?>
              </div>
            </div>

            <div class="alert alert-<?php 
              echo $registration['status'] === 'accepted' ? 'success' : 
                   ($registration['status'] === 'rejected' ? 'danger' : 
                   ($registration['status'] === 'verified' ? 'info' : 'warning')); 
            ?> text-center">
              <h4 class="mb-2">
                <i class="fa fa-<?php 
                  echo $registration['status'] === 'accepted' ? 'check-circle' : 
                       ($registration['status'] === 'rejected' ? 'times-circle' : 
                       ($registration['status'] === 'verified' ? 'info-circle' : 'clock')); 
                ?> me-2"></i>
                Status: 
                <?php 
                  $status_text = [
                    'pending' => 'Menunggu Verifikasi',
                    'verified' => 'Sudah Diverifikasi',
                    'accepted' => 'DITERIMA',
                    'rejected' => 'Ditolak'
                  ];
                  echo $status_text[$registration['status']] ?? 'Unknown';
                ?>
              </h4>
              <?php if ($registration['notes']): ?>
                <p class="mb-0"><small><?php echo e($registration['notes']); ?></small></p>
              <?php endif; ?>
            </div>

            <?php if ($registration['status'] === 'accepted'): ?>
              <div class="text-center mt-3">
                <a href="<?php echo base_url(); ?>/public/ppdb_print.php?reg_number=<?php echo e($registration['registration_number']); ?>" 
                   class="btn btn-success btn-lg" target="_blank">
                  <i class="fa fa-print me-2"></i>Cetak Kartu Pendaftaran
                </a>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
</div>

<?php require __DIR__ . '/_footer.php'; ?>
