<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
$db = get_db();
$row = $db->query("SELECT * FROM sambutan WHERE id=1")->fetch(PDO::FETCH_ASSOC);
include '_header.php';
?>
<div class="container py-4">
  <h1 class="mb-4">Sambutan Kepala Sekolah</h1>
  <div class="card mb-4 p-4">
    <div class="row align-items-center">
      <div class="col-md-3 text-center mb-3 mb-md-0">
        <?php if (!empty($row['foto'])): ?>
          <img src="../data/uploads/<?php echo e($row['foto']); ?>" alt="Foto Kepala Sekolah" class="img-fluid rounded shadow" style="max-height:180px;">
        <?php endif; ?>
        <div class="fw-bold mt-2"><?php echo e($row['nama']); ?></div>
        <div class="text-muted"><?php echo e($row['jabatan']); ?></div>
      </div>
      <div class="col-md-9">
        <div class="bg-light border rounded p-3" style="min-height:120px;">
          <?php echo $row && !empty($row['isi']) ? $row['isi'] : '<em>Belum diisi</em>'; ?>
        </div>
      </div>
    </div>
  </div>
</div>
<?php include '_footer.php'; ?>
